/*
LLL Programming Language Interpreter

Copyright (c) 2012 Lode Vandevenne
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
  * Neither the name of Lode Vandevenne nor the names of his contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#pragma once

#include <vector>
#include <string>
#include <map>
#include <iostream>

#include "parts.h"

Part* parseWire(std::vector<Connector>& stack, ConnectorMap& map,
                const Pos& start,
                std::vector<bool>& done0, std::vector<bool>& done1,
                const std::vector<char>& in, size_t w, size_t h);

/*
parse a diode part
*/
Part* parseDiode(std::vector<Connector>& stack, ConnectorMap& map,
                const Pos& pos,
                std::vector<bool>& done0, std::vector<bool>& done1,
                const std::vector<char>& in, size_t w, size_t h);

/*
parse a diode part
*/
Part* parseInvertor(std::vector<Connector>& stack, ConnectorMap& map,
                    const Pos& pos,
                    std::vector<bool>& done0, std::vector<bool>& done1,
                    const std::vector<char>& in, size_t w, size_t h);


/*
Parse input or output.
*/
Part* parseIO(std::vector<Connector>& stack, ConnectorMap& map,
              const Pos& start,
              std::vector<bool>& done0, std::vector<bool>& done1,
              const std::vector<char>& in, size_t w, size_t h);

/*
parse a xor wire part
*/
Part* parseXorWire(std::vector<Connector>& stack, ConnectorMap& map,
                   const Pos& start,
                   std::vector<bool>& done0, std::vector<bool>& done1,
                   const std::vector<char>& in, size_t w, size_t h);

Part* parseCounterWire(std::vector<Connector>& stack, ConnectorMap& map,
                       const Pos& start,
                       std::vector<bool>& done0, std::vector<bool>& done1,
                       const std::vector<char>& in, size_t w, size_t h);


/*
Parse a group of touching parts.
*/
void parseGroup(std::vector<Part*>& parts, ConnectorMap& map,
                Pos start,
                std::vector<bool>& done0, std::vector<bool>& done1,
                const std::vector<char>& in, size_t w, size_t h);
void parse(std::vector<Part*>& parts, const std::vector<char>& in, size_t w, size_t h);
