/*
Copyright (c) 2005-2006 Lode Vandevenne
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
  * Neither the name of Lode Vandevenne nor the names of his contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef input_h
#define input_h

#include <SDL/SDL.h>

namespace lpi
{

//////////////////////////////////////////
//                                      //
// II   N    N   PPPP   U   U  TTTTTTT  //
// II   NN   N   P   P  U   U    T      //
// II   N N  N   P   P  U   U    T      //
// II   N  N N   PPPP   U   U    T      //
// II   N   NN   P      U   U    T      //
// II   N    N   P       UUU     T      //
//                                      //
//////////////////////////////////////////

class Inkeys //this class contains which keys are pressed (need to do readKeys to get updated state)
{
  private:
  Uint8* keybuffer;
  int size; //the amount of keys filled in inkeys
  
  
  
  public:
  void readKeys();
  
  Inkeys();
  
  bool operator[](int index);
    
};


extern SDL_Event event;

extern Inkeys inkeys;
extern int mouseX;
extern int mouseY;
extern bool globalLMB; //left mouse button
extern bool globalRMB; //right mouse button
extern bool mouseWheelUp; //mouse wheel up
extern bool mouseWheelDown; //mouse wheel down
//extern int mouseBuffer[1280][1024];


void readKeys();
bool keyDown(int key);
bool keyPressed(int key, int index = 0);
bool pressedEnter(int index = 0);
void checkMouse();
int mouseXDiff();
int mouseYDiff();
int mouseXDiffWarp();
int mouseYDiffWarp();
void resetMouseDiffFunctions();

/*
warmup = "warmup time": how long it takes before the key starts repeating
rate = repetition rate of the key after the warmupTime
having released the key resets the warmup
timingIndex = index of variable that remembers key timing, so you can have different independent inputs
*/
int unicodeKey(int allowedChars, int warmup = 0.5, int rate = 0.025, int index = 0);

//these were moved from general to input because they depend so much on input
void sleep();
bool done();

} //namespace lpi

#endif //input_h
