/*
Copyright (c) 2005-2006 Lode Vandevenne
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
  * Neither the name of Lode Vandevenne nor the names of his contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <cmath>

#include "lpi_general.h"


namespace lpi
{

//using namespace std;



//****************************************************************************//
////////////////////////////////////////////////////////////////////////////////
//NON GRAPHICS//////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//****************************************************************************//


//Ends the program
void end()
{
  SDL_Quit();
  exit(1);
}



//function removed here as it couldn't work when multiple things test for doubleclicking
/*bool doubleClick(float time, bool button)*/

//Returns the time in integer milliseconds since the program started
Uint32 getTicks()
{
  return SDL_GetTicks();
}

double getRandom()
{
  int r = rand();
  if(r < 0) r = -r;
  r %= 256;
  return r / 256.0;
}


//this sorts objects based on their distance, and will at the same time also sort an ordered index
void combSort(std::vector<int> &order, std::vector<double> &dist)
{
  if(order.size() != dist.size()) return;
  int amount = order.size();
  
  int gap = amount;
  bool swapped = false;
  while(gap > 1 || swapped)
  {
    //shrink factor 1.3
    gap = (gap * 10) / 13;
    if(gap == 9 || gap == 10) gap = 11;
    if (gap < 1) gap = 1;
    swapped = false;
    for (int i = 0; i < amount - gap; i++)
    {
      int j = i + gap;
      if (dist[i] < dist[j])// <: from large to small, >: from small to large
      {
        int tempi; double tempf;
        tempf = dist[i]; dist[i] = dist[j]; dist[j] = tempf;
        tempi = order[i]; order[i] = order[j]; order[j] = tempi;
        swapped = true;
      }
    }
  }
}

int wrapmod(int i, int n) //wraps i between 0 and n, using the modulo operator
{
  if(i >= n) i = i % n;
  if(i < 0) i = (n - ((-i) % n)); //modulo division on negative values
  if(i == n) i = 0; //happens if i = -n, -2n, ...
  
  return i;
}

double clamp(double a, double low, double high)
{
  if(a < low) a = low;
  if(a > high) a = high;
  return a;
}

int clamp(int a, int low, int high)
{
  if(a < low) a = low;
  if(a > high) a = high;
  return a;
}

bool isPowerOfTwo(int n) //does not work properly if n is <= 0, then an extra test n > 0 should be added
{
  return !(n & (n - 1)); //this checks if the integer n is a power of two or not
}

/*
this will apply modulo division to a floating point number. by converting to integer and then taking modulo division, sometimes you don't get nice results because the integer is too small to contain the value of the floating point number. This function here tries to overcome that problem.
the return value is an integer in the range [0, m)
negative f is made positive and then the result is calculated (since this fucntion is supposed to be used to find digits).
*/
int floatMod(double f, int m)
{
  if(f < 0.0) f = -f;
  
  if(f < 1.0) return 0;
  
  double s = m; //subtractor
  while(f > s) s *= m;
  s /= m; //the above subtractor was one too large!
  
  while(s > m * m / 2) //I use m * m / 2 instead of m to avoid unprecisions
  {
    while(f > 0) f -= s;
    f += s;
    s /= m;
  }
  
  return int(f) % m;
}

/*
return the greatest common divider of the two given numbers, using Euclid's algorithm
*/
int gcd(int a, int b)
{
   while(b != 0)
   {
     int t = b;
     b = a % b;
     a = t;
   }
   return a;
}

float floatpow(float a, float b)
{
   return pow(a, b);
}

void encodeBase64(const std::vector<unsigned char>& in, std::string& out)
{
  const std::string chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  unsigned long bit24 = 0;
  unsigned long sextet0 = 0;
  unsigned long sextet1 = 0;
  unsigned long sextet2 = 0;
  unsigned long sextet3 = 0;
  unsigned long octet0 = 0;
  unsigned long octet1 = 0;
  unsigned long octet2 = 0;
  unsigned char char0 = 0;
  unsigned char char1 = 0;
  unsigned char char2 = 0;
  unsigned char char3 = 0;
  
  int size = in.size();
  
  int counter = 0; //per 19 (ie per 76 characters), a newline symbol is added
  
  out.clear();
  
  for(int pos = 0; pos < size; pos += 3)
  {
    octet0 = in[pos + 0];
    if(pos + 1 < size) octet1 = in[pos + 1];
    else octet1 = 0;
    if(pos + 2 < size) octet2 = in[pos + 2];
    else octet2 = 0;
    
    bit24 = 0;
    bit24 += 256 * 256 * octet0;
    bit24 +=       256 * octet1;
    bit24 +=             octet2;
    
    sextet0 = (bit24 / (64 * 64 * 64)) % 64;
    sextet1 = (bit24 / (     64 * 64)) % 64;
    sextet2 = (bit24 / (          64)) % 64;
    sextet3 = (bit24 / (           1)) % 64;
    
    char0 = chars[sextet0];
    char1 = chars[sextet1];
    char2 = chars[sextet2];
    char3 = chars[sextet3];
    
    if(pos + 2 < size)
    {
      out.push_back(char0);
      out.push_back(char1);
      out.push_back(char2);
      out.push_back(char3);
    }
    else if(pos + 1 < size)
    {
      out.push_back(char0);
      out.push_back(char1);
      out.push_back(char2);
      out.push_back('=');
    }
    else
    {
      out.push_back(char0);
      out.push_back(char1);
      out.push_back('=');
      out.push_back('=');
    }
    
    counter++;
    if(counter >= 19)
    {
      counter = 0;
      out.push_back(10); //newline character
    }
  }
}

void decodeBase64(const std::string& in, std::vector<unsigned char>& out)
{
  unsigned long bit24 = 0;
  unsigned long sextet0 = 0;
  unsigned long sextet1 = 0;
  unsigned long sextet2 = 0;
  unsigned long sextet3 = 0;
  unsigned long octet0 = 0;
  unsigned long octet1 = 0;
  unsigned long octet2 = 0;
  unsigned char char0 = 0;
  unsigned char char1 = 0;
  unsigned char char2 = 0;
  unsigned char char3 = 0;
  
  int size = in.size();
  
  out.clear();
  
  int counter = 0;  //to remove the newline characters
  
  for(int pos = 0; pos < size; pos += 4)
  {
    char0 = in[pos + 0];
    char1 = in[pos + 1];
    char2 = in[pos + 2];
    char3 = in[pos + 3];
    
    if(char0 >= 65 && char0 <= 90) sextet0 = char0 - 65;
    else if(char0 >= 97 && char0 <= 122) sextet0 = char0 - 71;
    else if(char0 == '+') sextet0 = 62;
    else if(char0 == '/') sextet0 = 63;
    else sextet0 = char0 + 4;
    
    if(char1 >= 65 && char1 <= 90) sextet1 = char1 - 65;
    else if(char1 >= 97 && char1 <= 122) sextet1 = char1 - 71;
    else if(char1 == '+') sextet1 = 62;
    else if(char1 == '/') sextet1 = 63;
    else sextet1 = char1 + 4;
    
    if(char2 >= 65 && char2 <= 90) sextet2 = char2 - 65;
    else if(char2 >= 97 && char2 <= 122) sextet2 = char2 - 71;
    else if(char2 == '+') sextet2 = 62;
    else if(char2 == '/') sextet2 = 63;
    else if(char2 == '=') sextet2 = 0;
    else sextet2 = char2 + 4;
    
    if(char3 >= 65 && char3 <= 90) sextet3 = char3 - 65;
    else if(char3 >= 97 && char3 <= 122) sextet3 = char3 - 71;
    else if(char3 == '+') sextet3 = 62;
    else if(char3 == '/') sextet3 = 63;
    else if(char3 == '=') sextet3 = 0;
    else sextet3 = char3 + 4;
    
    bit24 = 0;
    bit24 += 64 * 64 * 64 * sextet0;
    bit24 +=      64 * 64 * sextet1;
    bit24 +=           64 * sextet2;
    bit24 +=                sextet3;
    
    octet0 = (bit24 / (256 * 256)) % 256;
    octet1 = (bit24 / (      256)) % 256;
    octet2 = (bit24 / (        1)) % 256;
    
    
    if(char2 != '=')
    {
      out.push_back(octet0);
      out.push_back(octet1);
      out.push_back(octet2);
    }
    else if(char3 != '=')
    {
      out.push_back(octet0);
      out.push_back(octet1);
    }
    else
    {
      out.push_back(octet0);
    }
    
    counter++;
    if(counter >= 19)
    {
      counter = 0;
      pos++; //skip next newline character
    }
  }
}

} //namespace lpi
